'-------------------------------------------------
'-- Structural breaks in GDP series
'-- July 09
'-------------------------------------------------


'-------------------------------------------------
'-- I. Loading the file
'-------------------------------------------------


%the_path = "L:\MED\SDP\DRA\Projects\2009_Upper_Tsatsaronis\Prog\Eviews\FINAL_OUTPUT\"
cd %the_path

wfcreate(wf=exercise_unknown_dates, page = raw_data) q 1960Q1 2009Q1
read(S=Data) GDP.XLS 37


'-------------------------------------------------
'-- II. Deriving variables
'-------------------------------------------------

for %y AR BO BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NI NO PY PH RU LK SE TH TR UA GB US UY VE VN

	series level{%y} = log(rgdp{%y})		
	series dummy{%y} = 0

next

'Dummy variables

series dummy1ar=0
dummy1ar.fill(o=2001Q4,l) 1

series dummy2ar=0
dummy2ar.fill(o=1985q1,l) 1

series dummy3ar=0
dummy3ar.fill(o=1992q1,l) 1

dummybr.fill(o=1991q1,l) 1

series dummy1co=0
dummy1co.fill(o=1998q4,l) 1
series dummy2co=0
dummy2co.fill(o=1998q3,l) 1

series dummy1dm=0
dummy1dm.fill(o=2003q2,l) 1

series dummy2dm=0
dummy2dm.fill(o=2003q1,l) 1

dummyec.fill(o=1999q3,l) 1

dummyhr.fill(o=2000q1,l) 1

series dummy1ee=0
dummy1ee.fill(o=1992q3,l) 1

series dummy2ee=0
dummy2ee.fill(o=1992q1,l) 1

series dummy3ee=0
dummy3ee.fill(o=2001q4,l) 1

series dummy1fi=0
dummy1fi.fill(o=1991q3,l) 1

series dummy2fi=0
dummy2fi.fill(o=1991q2,l) 1

series dummy3fi=0
dummy3fi.fill(o=1991q1,l) 1

dummygh.fill(o=1985q1,l) 1

dummyid.fill(o=1998q2,l) 1

series dummy1jm=0
dummy1jm.fill(o=1996q2,l) 1

series dummy2jm = 0
dummy2jm.fill(o=1997q1,l) 1

dummyjp.fill(o=1998q1,l) 1

series dummy1kr=0
dummy1kr.fill(o=1998q1,l) 1

series dummy2kr=0
dummy2kr.fill(o=1997q4,l) 1

series dummy1my=0
dummy1my.fill(o=1998q1,l) 1
series dummy2my=0
dummy2my.fill(o=1998q2,l) 1

dummymx.fill(o=1997q2,l) 1

series dummy1se=0
dummy1se.fill(o=1992q3,l) 1

series dummy2se=0
dummy2se.fill(o=1991q3,l) 1

series dummy1th=0
dummy1th.fill(o=1998q1,l) 1
series dummy2th=0
dummy2th.fill(o=1997q4,l) 1

dummytr.fill(o=2001q1,l) 1

series dummy1uy=0
dummy1uy.fill(o=2002q1,l) 1

series dummy2uy=0
dummy2uy.fill(o=2001q3,l) 1



'--------------------------------------------------------------
'-- III. Computing the underlying model
'--------------------------------------------------------------


''III.1: Trend
'-----------------------



for %y AR BO BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NI NO PY PH RU LK SE TH TR UA UY VE VN

	equation eq_{%y}.ls(n)			level{%y}  c @trend 
		
next 




'--------------------------------------------------------------
'-- IV. Break in series
'-------------------------------------------------------------


'Break test known: Chow
	
equation eq_chow_ar_all.ls(n)		levelar c dummy1ar @trend dummy1ar*@trend
equation eq_chow_ar_c.ls(n)			levelar c dummy2ar @trend 
equation eq_chow_ar_trend.ls(n)		levelar c @trend dummy3ar*@trend

equation eq_chow_br_all.ls(n)		levelbr c dummybr @trend dummybr*@trend
equation eq_chow_br_c.ls(n)			levelbr c dummybr @trend 
equation eq_chow_br_trend.ls(n)		levelbr c  @trend dummybr*@trend

equation eq_chow_co_all.ls(n)		levelco c dummy1co @trend dummy1co*@trend
equation eq_chow_co_c.ls(n)			levelco c dummy1co @trend 
equation eq_chow_co_trend.ls(n)		levelco c  @trend dummy2co*@trend

equation eq_chow_dm_all.ls(n)		leveldm c dummy1dm @trend dummy1dm*@trend
equation eq_chow_dm_c.ls(n)		leveldm c dummy2dm @trend 

equation eq_chow_ec_all.ls(n)		levelec c dummyec @trend dummyec*@trend

equation eq_chow_ee_all.ls(n)		levelee c dummy1ee @trend dummy1ee*@trend
equation eq_chow_ee_c.ls(n)			levelee c dummy2ee @trend 
equation eq_chow_ee_trend.ls(n)		levelee c @trend dummy3ee*@trend

equation eq_chow_fi_all.ls(n)			levelfi c dummy1fi @trend dummy1fi*@trend
equation eq_chow_fi_c.ls(n)			levelfi c dummy2fi @trend 
equation eq_chow_fi_trend.ls(n)		levelfi c @trend dummy3fi*@trend
	
equation eq_chow_gh_all.ls(n)		levelgh c dummygh @trend dummygh*@trend
equation eq_chow_gh_c.ls(n)			levelgh c dummygh @trend

equation eq_chow_id_all.ls(n)		levelid c dummyid @trend dummyid*@trend
equation eq_chow_id_c.ls(n)			levelid c dummyid @trend 
equation eq_chow_id_trend.ls(n)		levelid c @trend dummyid*@trend

equation eq_chow_jm_all.ls(n)		leveljm c dummy1jm @trend dummy1jm*@trend
equation eq_chow_jm_trend.ls(n)		leveljm c @trend dummy2jm*@trend
	
equation eq_chow_kr_c.ls(n)			levelkr c dummy1kr @trend 
equation eq_chow_kr_trend.ls(n)		levelkr c @trend dummy2kr*@trend

equation eq_chow_my_all.ls(n)		levelmy c dummy1my @trend dummy1my*@trend
equation eq_chow_my_trend.ls(n)		levelmy c @trend dummy2my*@trend

equation eq_chow_mx_trend.ls(n)		levelmx c @trend dummymx*@trend

equation eq_chow_hr_trend.ls(n)		levelhr c @trend dummyhr*@trend

equation eq_chow_jp_trend.ls(n)		leveljp c @trend dummyjp*@trend

equation eq_chow_se_all.ls(n)		levelse c dummy1se @trend dummy1se*@trend
equation eq_chow_se_c.ls(n)			levelse c dummy2se @trend

equation eq_chow_th_all.ls(n)		levelth c dummy1th @trend dummy1th*@trend
equation eq_chow_th_c.ls(n)			levelth c dummy1th @trend 
equation eq_chow_th_trend.ls(n)		levelth c  @trend dummy2th*@trend

equation eq_chow_tr_all.ls(n)			leveltr c dummytr @trend dummytr*@trend

equation eq_chow_uy_all.ls(n)		leveluy c dummy1uy @trend dummy1uy*@trend
equation eq_chow_uy_c.ls(n)		leveluy c dummy2uy @trend 





table(41,14) variance

setcell (variance,1,1,"Size of unknown break date","l")
variance.settextcolor(1,1) blue
variance.setfont(1,1) +b 14pt
variance.setfont(2,1) -b 10pt
setline(variance,4)

variance(5,2)="Both level and trend"
variance(6,2)="a1"
variance(6,3)="t1"
variance(6,4)="t2"
variance(6,5)="b1"
variance(6,6)="t1"
variance(6,7)="t2"
variance(5,8)="Level"
variance(6,8)="a1"
variance(6,9)="t1"
variance(6,10)="t2"
variance(5,11)="Trend"
variance(6,11)="b1"
variance(6,12)="t1"
variance(6,13)="t2"

!i = 7
for %x AR BR CO EE FI  ID TH


	variance(!i,1)=%x
	variance(!i,2)=eq_chow_{%x}_all.@coefs(2)
	variance(!i,3)=eq_chow_{%x}_all.@coefs(2)-eq_chow_{%x}_all.@stderrs(2)
	variance(!i,4)=eq_chow_{%x}_all.@coefs(2)+eq_chow_{%x}_all.@stderrs(2)
	variance(!i,5)=eq_chow_{%x}_all.@coefs(4)
	variance(!i,6)=eq_chow_{%x}_all.@coefs(4)-eq_chow_{%x}_all.@stderrs(4)
	variance(!i,7)=eq_chow_{%x}_all.@coefs(4)+eq_chow_{%x}_all.@stderrs(4)
	variance(!i,8)=eq_chow_{%x}_c.@coefs(2)
	variance(!i,9)=eq_chow_{%x}_c.@coefs(2)-eq_chow_{%x}_c.@stderrs(2)
	variance(!i,10)=eq_chow_{%x}_c.@coefs(2)+eq_chow_{%x}_c.@stderrs(2)
	variance(!i,11)=eq_chow_{%x}_trend.@coefs(3)
	variance(!i,12)=eq_chow_{%x}_trend.@coefs(3)-eq_chow_{%x}_trend.@stderrs(3)
	variance(!i,13)=eq_chow_{%x}_trend.@coefs(3)+eq_chow_{%x}_trend.@stderrs(3)

!i = !i+1
next

for %x EC TR

	variance(!i,1)=%x
	variance(!i,2)=eq_chow_{%x}_all.@coefs(2)
	variance(!i,3)=eq_chow_{%x}_all.@coefs(2)-eq_chow_{%x}_all.@stderrs(2)
	variance(!i,4)=eq_chow_{%x}_all.@coefs(2)+eq_chow_{%x}_all.@stderrs(2)
	variance(!i,5)=eq_chow_{%x}_all.@coefs(4)
	variance(!i,6)=eq_chow_{%x}_all.@coefs(4)-eq_chow_{%x}_all.@stderrs(4)
	variance(!i,7)=eq_chow_{%x}_all.@coefs(4)+eq_chow_{%x}_all.@stderrs(4)

!i = !i+1
next

for %x GH SE UY DM

	variance(!i,1)=%x
	variance(!i,2)=eq_chow_{%x}_all.@coefs(2)
	variance(!i,3)=eq_chow_{%x}_all.@coefs(2)-eq_chow_{%x}_all.@stderrs(2)
	variance(!i,4)=eq_chow_{%x}_all.@coefs(2)+eq_chow_{%x}_all.@stderrs(2)
	variance(!i,5)=eq_chow_{%x}_all.@coefs(4)
	variance(!i,6)=eq_chow_{%x}_all.@coefs(4)-eq_chow_{%x}_all.@stderrs(4)
	variance(!i,7)=eq_chow_{%x}_all.@coefs(4)+eq_chow_{%x}_all.@stderrs(4)
	variance(!i,8)=eq_chow_{%x}_c.@coefs(2)
	variance(!i,9)=eq_chow_{%x}_c.@coefs(2)-eq_chow_{%x}_c.@stderrs(2)
	variance(!i,10)=eq_chow_{%x}_c.@coefs(2)+eq_chow_{%x}_c.@stderrs(2)
	
!i = !i+1
next

for %x JM MY

	variance(!i,1)=%x
	variance(!i,2)=eq_chow_{%x}_all.@coefs(2)
	variance(!i,3)=eq_chow_{%x}_all.@coefs(2)-eq_chow_{%x}_all.@stderrs(2)
	variance(!i,4)=eq_chow_{%x}_all.@coefs(2)+eq_chow_{%x}_all.@stderrs(2)
	variance(!i,5)=eq_chow_{%x}_all.@coefs(4)
	variance(!i,6)=eq_chow_{%x}_all.@coefs(4)-eq_chow_{%x}_all.@stderrs(4)
	variance(!i,7)=eq_chow_{%x}_all.@coefs(4)+eq_chow_{%x}_all.@stderrs(4)
	variance(!i,11)=eq_chow_{%x}_trend.@coefs(3)
	variance(!i,12)=eq_chow_{%x}_trend.@coefs(3)-eq_chow_{%x}_trend.@stderrs(3)
	variance(!i,13)=eq_chow_{%x}_trend.@coefs(3)+eq_chow_{%x}_trend.@stderrs(3)

!i = !i+1
next


for %x KR
	
	variance(!i,1)=%x
	variance(!i,8)=eq_chow_{%x}_c.@coefs(2)
	variance(!i,9)=eq_chow_{%x}_c.@coefs(2)-eq_chow_{%x}_c.@stderrs(2)
	variance(!i,10)=eq_chow_{%x}_c.@coefs(2)+eq_chow_{%x}_c.@stderrs(2)
	variance(!i,11)=eq_chow_{%x}_trend.@coefs(3)
	variance(!i,12)=eq_chow_{%x}_trend.@coefs(3)-eq_chow_{%x}_trend.@stderrs(3)
	variance(!i,13)=eq_chow_{%x}_trend.@coefs(3)+eq_chow_{%x}_trend.@stderrs(3)

!i = !i+1
next


for %x MX HR JP
	
	variance(!i,1)=%x
	variance(!i,11)=eq_chow_{%x}_trend.@coefs(3)
	variance(!i,12)=eq_chow_{%x}_trend.@coefs(3)-eq_chow_{%x}_trend.@stderrs(3)
	variance(!i,13)=eq_chow_{%x}_trend.@coefs(3)+eq_chow_{%x}_trend.@stderrs(3)

!i = !i+1
next

save exercise_unknown_dates

